<?php
// Set headers for API response
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

error_reporting(0);
include_once 'db.php';

try {
    // Fetch search parameter from the request
    $search = isset($_GET['search']) ? trim($_GET['search']) : '';

    // Base SQL query
    $sqlcategory = "
        SELECT 
            p.Product_id AS product_id,
            p.Product_name AS product_name,
            p.Purchase_price AS purchase_price,
            p.MRP AS mrp,
            p.Selling_price AS selling_price,
            p.price,
            p.category,
            p.Variant AS variant,
            p.Product_description AS product_description,
            p.M_unit AS m_unit,
            p.HSN AS hsn,
            p.SKU AS sku,
            p.qty,
            p.Price_type AS price_type,
            p.Product_image AS product_image,
            p.Sale_price_tax AS sale_price_tax,
            p.Purchase_price_tax AS purchase_price_tax,
            p.Shipping_weight AS shipping_weight,
            p.Tax_percentage AS tax_percentage,
            p.tax,
            p.Discount_percentage AS discount_percentage,
            p.Discount_value AS discount_value,
            p.Packing_date AS packing_date,
            p.Expiry_date AS expiry_date,
            p.Location_rack AS location_rack,
            p.Brand AS brand,
            p.Youtube_url AS youtube_url,
            p.barcode,
            p.minqty,
            p.maxqty,
            p.Creater_id AS creater_id,
            p.Edit_id AS edit_id,
            p.mode,
            p.date,
            p.Delete_status AS delete_status
        FROM 
            product p
        WHERE 
            p.Delete_status = '0' 
            AND p.mode = '1' AND p.qty >5
    ";

    // If search input is provided, filter results
    if (!empty($search)) {
        $search = mysqli_real_escape_string($conn, $search);
        $sqlcategory .= " AND (p.Product_name LIKE '%$search%' OR p.Product_id LIKE '%$search%' OR p.SKU LIKE '%$search%')";
    }

    $sqlcategory .= " GROUP BY p.Product_id"; // Group by Product_id

    $result = mysqli_query($conn, $sqlcategory);

    // Initialize items array
    $items = [];

    while ($row = $result->fetch_assoc()) {
        $items[] = [
            'id' => $row['product_id'] ?? '0',
            'name' => $row['product_name'] ?? 'N/A',
            'qty' => $row['qty'] ?? '0',
            'mrp' => $row['mrp'] ?? '0',
            'saleprice' => $row['selling_price'] ?? '0',
            'price' => $row['price'] ?? '0',
            'productimage' => $row['product_image'],
            'sale_price_tax' => $row['sale_price_tax'],
            'tax' => $row['tax'],
            'tax_percentage' => $row['tax_percentage'],
            'discountpercentage' => $row['discount_percentage'],
            'discountvalue' => $row['discount_value'],
        ];
    }

    // Return items as JSON
    echo json_encode($items, JSON_PRETTY_PRINT);

} catch (Exception $e) {
    // Handle errors and return as JSON
    echo json_encode([
        'status' => 'error',
        'message' => 'An error occurred while fetching product data.',
        'error' => $e->getMessage()
    ]);
}

// Close the database connection
$conn->close();
?>
